/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.CustomCardMaker.GaussianFilter;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.Icon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class CustomCardMaker
extends CardMaker {
    public String exportFolder = "cardCreator";
    public static String templateFolder = "legendary" + File.separator + "templates" + File.separator + "custom";
    private boolean debug = true;
    public static int cardWidth = 750;
    public static int cardHeight = 1050;
    public static int dpi = 300;
    boolean exportImage = false;
    public boolean exportToPNG = true;
    public CustomCard card;
    public BufferedWriter bwErr = null;
    public CustomTemplate template = null;

    public void setCard(CustomCard c) {
        this.card = c;
        this.template = c.template;
    }

    public void populateCard() {
        this.card = new CustomCard();
    }

    public void populateBlankCard() {
        this.card = new CustomCard();
    }

    public static CustomCard getBlankCard() {
        CustomCard card = new CustomCard();
        return card;
    }

    @Override
    public BufferedImage generateCard() {
        int type = 2;
        if (this.exportToPNG) {
            type = 2;
        }
        BufferedImage image = new BufferedImage(cardWidth, cardHeight, type);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g = this.setGraphicsHints(g);
        if (this.template != null) {
            for (CustomElement element : this.template.elements) {
                element.drawElement(g);
            }
        }
        if (this.exportImage) {
            this.exportImage(image);
        }
        g.dispose();
        return image;
    }

    public void exportImage(BufferedImage image) {
        try {
            if (this.exportToPNG) {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".png");
                this.exportToPNG(image, newFile);
            } else {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".jpg");
                this.exportToJPEG(image, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        File dir = new File(this.exportFolder);
        dir.mkdirs();
        ImageIO.write((RenderedImage)bi, "jpeg", newFile);
    }

    public void exportToPNG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        ImageIO.write((RenderedImage)image, "png", newFile);
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    private BufferedImage blackoutImage(BufferedImage image, Color blackoutColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, blackoutColor.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    private void drawUnderlay(BufferedImage bi, Graphics g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout, Color underlayColour) {
        BufferedImage blackout = new BufferedImage(cardWidth, cardHeight, type);
        blackout.getGraphics().drawImage(bi, x, y, null);
        blackout = this.blackoutImage(blackout, underlayColour);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout, underlayColour);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage(bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage(bi3, 0, 0, null);
            }
        } else {
            g.drawImage(blackout, 0, 0, null);
        }
    }

    private BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    private BufferedImage expandBlackout(BufferedImage image, int expandBlackout, Color blackoutColor) {
        BufferedImage expand = new BufferedImage(cardWidth, cardHeight, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    private Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    private BufferedImage createRareBacking(int x, int y, int x2, int y2) {
        BufferedImage bi = new BufferedImage(cardWidth, cardHeight, 2);
        Graphics g2 = bi.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(x, y, x2 - x, y2 - y);
        return bi;
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    public BufferedImage resizeImagePS(BufferedImage bi) {
        double scale = 2.0;
        double xPadding = 0.043;
        double yPadding = 0.08;
        String exportType = "jpg";
        ImageIcon imageIcon = new ImageIcon(bi);
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int xPad = (int)((double)imageIcon.getIconWidth() * scale * xPadding);
        int fullW = w + xPad + xPad;
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int yPad = (int)((double)imageIcon.getIconHeight() * scale * yPadding);
        int fullH = h + yPad + yPad;
        int type = 2;
        if (exportType.equals("jpg")) {
            type = 1;
        }
        BufferedImage image = new BufferedImage(fullW, fullH, type);
        Graphics g = image.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, fullW, fullH);
        g.drawImage(imageIcon.getImage(), xPad, yPad, w + xPad, h + yPad, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    private BufferedImage getFadedBackground(ImageIcon ii) {
        BufferedImage bi = new BufferedImage(cardWidth, cardHeight, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(ii.getImage(), 0, 0, cardWidth, cardHeight, null);
        int width = bi.getWidth();
        int height = bi.getHeight();
        int fadeHeight = this.getPercentage(cardHeight, 0.14);
        double increment = 255.0 / (double)fadeHeight;
        int alpha = 0;
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    if (yy <= cardHeight / 2 + fadeHeight / 2) {
                        alpha = (int)((double)(cardHeight / 2 + fadeHeight / 2 - yy) * increment);
                        if (alpha > 255) {
                            alpha = 255;
                        }
                        if (yy <= cardHeight / 2 + fadeHeight / 2 && xx == 0) {
                            System.out.println(String.valueOf(yy) + ":" + alpha);
                        }
                    } else {
                        alpha = 0;
                    }
                    int col = alpha << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        g.dispose();
        return bi;
    }

    private BufferedImage clearHalfImage(BufferedImage bi, boolean leftHalf) {
        Graphics2D g2D = (Graphics2D)bi.getGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = null;
        rect = !leftHalf ? new Rectangle2D.Double(0.0, 0.0, bi.getWidth() / 2, bi.getHeight()) : new Rectangle2D.Double(bi.getWidth() / 2, 0.0, bi.getWidth(), bi.getHeight());
        g2D.fill(rect);
        g2D.dispose();
        return bi;
    }

    private Graphics2D getGraphics(BufferedImage bi) {
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    private Graphics2D setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }
}

